/*
 * Decompiled with CFR 0.152.
 */
package com.dlconsultant.infolognl.charts;

import com.dlconsultant.infolognl.charts.DefaultChartLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Spacer;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.MovingAverage;
import org.jfree.data.SeriesException;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public class TimeSerieDataSetChartLoader
extends DefaultChartLoader {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public TimeSerieDataSetChartLoader(Properties props) {
        super(props);
    }

    public JFreeChart getChart() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        String precisionString = "year";
        if (this._properties.getProperty("time.precision") != null) {
            precisionString = this._properties.getProperty("time.precision");
        }
        int precision = 1;
        if (precisionString.equalsIgnoreCase("year")) {
            precision = 1;
        } else if (precisionString.equalsIgnoreCase("month")) {
            precision = 2;
        } else if (precisionString.equalsIgnoreCase("day")) {
            precision = 3;
        } else if (precisionString.equalsIgnoreCase("week")) {
            precision = 4;
        } else if (precisionString.equalsIgnoreCase("hour")) {
            precision = 5;
        } else if (precisionString.equalsIgnoreCase("minute")) {
            precision = 6;
        } else if (precisionString.equalsIgnoreCase("second")) {
            precision = 7;
        }
        TimeSeries serie = null;
        int i = 1;
        while (((Hashtable)this._properties).containsKey("time.serie" + i + ".date1")) {
            String serieName = "";
            if (this._properties.getProperty("time.serie" + i + ".name") != null) {
                serieName = this._properties.getProperty("time.serie" + i + ".name");
            }
            switch (precision) {
                case 1: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Year");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                    break;
                }
                case 2: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Month");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                    break;
                }
                case 3: {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Day");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                    break;
                }
                case 4: {
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Week");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                    break;
                }
                case 5: {
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Hour");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                    break;
                }
                case 6: {
                    Class<?> clazz = class$5;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Minute");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                    break;
                }
                case 7: {
                    Class<?> clazz = class$6;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Second");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                    break;
                }
                default: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.jfree.data.time.Year");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serie = new TimeSeries(serieName, (Class)clazz);
                }
            }
            int j = 1;
            while (((Hashtable)this._properties).containsKey("time.serie" + i + ".date" + j)) {
                try {
                    Date ladate;
                    String dateString = this._properties.getProperty("time.serie" + i + ".date" + j);
                    String value = this._properties.getProperty("time.serie" + i + ".value" + j);
                    if (value != null && dateString != null && (ladate = this.convertDate(dateString)) != null) {
                        Double d = new Double(value);
                        switch (precision) {
                            case 1: {
                                serie.add((RegularTimePeriod)new Year(ladate), (Number)d);
                                break;
                            }
                            case 2: {
                                serie.add((RegularTimePeriod)new Month(ladate), (Number)d);
                                break;
                            }
                            case 3: {
                                serie.add((RegularTimePeriod)new Day(ladate), (Number)d);
                                break;
                            }
                            case 4: {
                                serie.add((RegularTimePeriod)new Week(ladate), (Number)d);
                                break;
                            }
                            case 5: {
                                serie.add((RegularTimePeriod)new Hour(ladate), (Number)d);
                                break;
                            }
                            case 6: {
                                serie.add((RegularTimePeriod)new Minute(ladate), (Number)d);
                                break;
                            }
                            case 7: {
                                serie.add((RegularTimePeriod)new Second(ladate), (Number)d);
                                break;
                            }
                            default: {
                                serie.add((RegularTimePeriod)new Year(ladate), (Number)d);
                                break;
                            }
                        }
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (SeriesException e) {
                    // empty catch block
                }
                ++j;
            }
            dataset.addSeries(serie);
            ++i;
        }
        String moyenne = this._properties.getProperty("time.moyenne");
        String moyenneTexte = this._properties.getProperty("time.moyenne.texte");
        if (moyenneTexte == null) {
            moyenneTexte = "(Average)";
        }
        if (moyenne != null && moyenne.equalsIgnoreCase("true")) {
            TimeSeriesCollection dataset2 = MovingAverage.createMovingAverage((TimeSeriesCollection)dataset, (String)(" " + moyenneTexte), (int)serie.getItemCount(), (int)0);
            int i2 = 0;
            while (i2 < dataset2.getSeriesCount()) {
                dataset.addSeries(dataset2.getSeries(i2));
                ++i2;
            }
        }
        JFreeChart chart = this.createChart((XYDataset)dataset, precision);
        if (this.isLegendVisible()) {
            StandardLegend legend = (StandardLegend)chart.getLegend();
            legend.setAnchor(this.getLegendAnchor());
        }
        return chart;
    }

    private Date convertDate(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSS");
        ParsePosition pos = new ParsePosition(0);
        Date ladate = formatter.parse(dateString, pos);
        return ladate;
    }

    private JFreeChart createChart(XYDataset dataset, int precision) {
        XYItemRenderer renderer;
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)this.getTitle(), (String)this._properties.getProperty("time.libelle.temps"), (String)this._properties.getProperty("time.libelle.valeurs"), (XYDataset)dataset, (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        StandardLegend sl = (StandardLegend)chart.getLegend();
        sl.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        String sommet = this._properties.getProperty("time.sommet.visible");
        if (sommet != null && sommet.equalsIgnoreCase("true") && (renderer = plot.getRenderer()) instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setPlotShapes(true);
            rr.setShapesFilled(true);
        }
        this.setLineStroke(dataset, plot);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        switch (precision) {
            case 1: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy"));
                break;
            }
            case 2: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MM-yyyy"));
                break;
            }
            case 3: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
                break;
            }
            case 4: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM ww"));
                break;
            }
            case 5: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"));
                break;
            }
            case 6: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"));
                break;
            }
            case 7: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                break;
            }
            default: {
                axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy"));
            }
        }
        return chart;
    }

    private void setLineStroke(XYDataset data, XYPlot plot) {
        BasicStroke stroke = new BasicStroke(2.0f);
        int i = 0;
        while (i < data.getSeriesCount()) {
            plot.getRenderer().setSeriesStroke(i, (Stroke)stroke);
            ++i;
        }
    }
}

