/*
 * Decompiled with CFR 0.152.
 */
package com.dlconsultant.infolognl.charts;

import com.dlconsultant.infolognl.charts.DefaultChartLoader;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.Pie3DPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;

public class PieChartLoader
extends DefaultChartLoader {
    public PieChartLoader(Properties props) {
        super(props);
    }

    public JFreeChart getChart() {
        DefaultPieDataset data = new DefaultPieDataset();
        int i = 1;
        while (((Hashtable)this._properties).containsKey("pie.key" + i)) {
            String cle = this._properties.getProperty("pie.key" + i);
            String valeur = this._properties.getProperty("pie.value" + i);
            Double d = new Double(valeur);
            data.setValue((Comparable)((Object)cle), (Number)d);
            ++i;
        }
        JFreeChart chart = null;
        String type = this._properties.getProperty("chart.type");
        if (type.equalsIgnoreCase("pie")) {
            chart = this.createPieChart(data);
        }
        if (type.equalsIgnoreCase("pie3D")) {
            chart = this.createPie3DChart(data);
        }
        if (this.isLegendVisible()) {
            StandardLegend legend = (StandardLegend)chart.getLegend();
            legend.setAnchor(this.getLegendAnchor());
        }
        return chart;
    }

    private JFreeChart createPie3DChart(DefaultPieDataset data) {
        JFreeChart chart = ChartFactory.createPie3DChart((String)this.getTitle(), (PieDataset)data, (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        Pie3DPlot plot = (Pie3DPlot)chart.getPlot();
        plot.setForegroundAlpha(0.6f);
        plot.setInteriorGap(0.33);
        plot.setSectionLabelType(5);
        plot.setNoDataMessage("No data available");
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        plot.setRadius(0.7);
        if (this._properties.getProperty("pie.rotate").equalsIgnoreCase("true")) {
            plot.setStartAngle(270.0);
            plot.setDirection(1);
            Rotator rotator = new Rotator(plot);
            rotator.start();
        }
        return chart;
    }

    private JFreeChart createPieChart(DefaultPieDataset data) {
        JFreeChart chart = ChartFactory.createPieChart((String)this.getTitle(), (PieDataset)data, (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setForegroundAlpha(0.6f);
        plot.setInteriorGap(0.33);
        plot.setSectionLabelType(5);
        plot.setNoDataMessage("No data available");
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        plot.setRadius(0.7);
        int nb = data.getItemCount();
        int i = 1;
        while (i <= nb) {
            String cle = this._properties.getProperty("pie.exploded" + i);
            if (cle != null && cle.equalsIgnoreCase("true")) {
                plot.setExplodePercent(i - 1, 1.0);
            }
            ++i;
        }
        return chart;
    }

    class Rotator
    extends Timer
    implements ActionListener {
        private Pie3DPlot plot;
        private int angle = 270;

        Rotator(Pie3DPlot plot) {
            super(100, null);
            this.plot = plot;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent event) {
            this.plot.setStartAngle((double)this.angle);
            ++this.angle;
            if (this.angle == 360) {
                this.angle = 0;
            }
        }
    }
}

