/*
 * Decompiled with CFR 0.152.
 */
package com.dlconsultant.infolognl.charts;

import com.dlconsultant.infolognl.charts.DefaultChartLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;

public class CategoryDataSetChartLoader
extends DefaultChartLoader {
    public CategoryDataSetChartLoader(Properties props) {
        super(props);
    }

    public JFreeChart getChart() {
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        ArrayList<String> series = new ArrayList<String>();
        int i = 1;
        while (((Hashtable)this._properties).containsKey("serie.name" + i)) {
            if (this._properties.getProperty("serie.name" + i) != null) {
                series.add(this._properties.getProperty("serie.name" + i));
            }
            ++i;
        }
        ArrayList<String> categories = new ArrayList<String>();
        int i2 = 1;
        while (((Hashtable)this._properties).containsKey("category.name" + i2)) {
            if (this._properties.getProperty("category.name" + i2) != null) {
                categories.add(this._properties.getProperty("category.name" + i2));
            }
            ++i2;
        }
        Iterator seriesIt = ((AbstractList)series).iterator();
        while (seriesIt.hasNext()) {
            String serieName = (String)seriesIt.next();
            Iterator categoriesIt = ((AbstractList)categories).iterator();
            while (categoriesIt.hasNext()) {
                String valeur;
                String categoryName = (String)categoriesIt.next();
                String cle = serieName + '.' + categoryName;
                if (!((Hashtable)this._properties).containsKey(cle) || (valeur = this._properties.getProperty(cle)) == null) continue;
                try {
                    Double db = new Double(valeur);
                    data.addValue((Number)db, (Comparable)((Object)serieName), (Comparable)((Object)categoryName));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        JFreeChart chart = null;
        String type = this._properties.getProperty("chart.type");
        if (type.equalsIgnoreCase("bar3D")) {
            chart = this.createBarChart3DChart(data);
        }
        if (type.equalsIgnoreCase("bar")) {
            chart = this.createBarChart(data);
        }
        if (type.equalsIgnoreCase("area")) {
            chart = this.createAreaChart(data);
        }
        if (type.equalsIgnoreCase("stackedarea")) {
            chart = this.createStackedAreaChart(data);
        }
        if (type.equalsIgnoreCase("stackedbar")) {
            chart = this.createStackedBarChart(data);
        }
        if (type.equalsIgnoreCase("stackedbar3d")) {
            chart = this.createStackedBarChart3D(data);
        }
        if (type.equalsIgnoreCase("linechart")) {
            chart = this.createLineChart(data);
        }
        if (this.isLegendVisible()) {
            StandardLegend legend = (StandardLegend)chart.getLegend();
            legend.setAnchor(this.getLegendAnchor());
        }
        return chart;
    }

    private JFreeChart createBarChart3DChart(DefaultCategoryDataset data) {
        JFreeChart chart = ChartFactory.createBarChart3D((String)this.getTitle(), (String)this._properties.getProperty("series.name"), (String)this._properties.getProperty("categories.name"), (CategoryDataset)data, (PlotOrientation)this.getPlotOrientation(), (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.6f);
        this.setBarColors(data, plot);
        return chart;
    }

    private void setBarColors(DefaultCategoryDataset data, CategoryPlot plot) {
        int i = 0;
        while (i < data.getRowCount()) {
            Color color = Color.red;
            if (((Hashtable)this._properties).containsKey(data.getRowKey(i) + ".color")) {
                String couleur = this._properties.getProperty(data.getRowKey(i) + ".color");
                try {
                    color = Color.decode(couleur);
                    plot.getRenderer().setSeriesPaint(i, (Paint)color);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void setLineStroke(DefaultCategoryDataset data, CategoryPlot plot) {
        BasicStroke stroke = new BasicStroke(2.0f);
        int i = 0;
        while (i < data.getRowCount()) {
            plot.getRenderer().setSeriesStroke(i, (Stroke)stroke);
            ++i;
        }
    }

    private JFreeChart createBarChart(DefaultCategoryDataset data) {
        JFreeChart chart = ChartFactory.createBarChart((String)this.getTitle(), (String)this._properties.getProperty("categories.name"), (String)this._properties.getProperty("series.name"), (CategoryDataset)data, (PlotOrientation)this.getPlotOrientation(), (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.6f);
        this.setBarColors(data, plot);
        return chart;
    }

    private JFreeChart createAreaChart(DefaultCategoryDataset data) {
        JFreeChart chart = ChartFactory.createAreaChart((String)this.getTitle(), (String)this._properties.getProperty("categories.name"), (String)this._properties.getProperty("series.name"), (CategoryDataset)data, (PlotOrientation)this.getPlotOrientation(), (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.6f);
        this.setBarColors(data, plot);
        return chart;
    }

    private JFreeChart createStackedAreaChart(DefaultCategoryDataset data) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)this.getTitle(), (String)this._properties.getProperty("categories.name"), (String)this._properties.getProperty("series.name"), (CategoryDataset)data, (PlotOrientation)this.getPlotOrientation(), (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.6f);
        this.setBarColors(data, plot);
        return chart;
    }

    private JFreeChart createStackedBarChart(DefaultCategoryDataset data) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)this.getTitle(), (String)this._properties.getProperty("categories.name"), (String)this._properties.getProperty("series.name"), (CategoryDataset)data, (PlotOrientation)this.getPlotOrientation(), (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.6f);
        this.setBarColors(data, plot);
        return chart;
    }

    private JFreeChart createStackedBarChart3D(DefaultCategoryDataset data) {
        JFreeChart chart = ChartFactory.createStackedBarChart3D((String)this.getTitle(), (String)this._properties.getProperty("categories.name"), (String)this._properties.getProperty("series.name"), (CategoryDataset)data, (PlotOrientation)this.getPlotOrientation(), (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.6f);
        this.setBarColors(data, plot);
        return chart;
    }

    private JFreeChart createLineChart(DefaultCategoryDataset data) {
        JFreeChart chart = ChartFactory.createLineChart((String)this.getTitle(), (String)this._properties.getProperty("categories.name"), (String)this._properties.getProperty("series.name"), (CategoryDataset)data, (PlotOrientation)this.getPlotOrientation(), (boolean)this.isLegendVisible(), (boolean)this.areTooltipsVisible(), (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(0.6f);
        this.setBarColors(data, plot);
        this.setLineStroke(data, plot);
        return chart;
    }
}

