/*
 * Decompiled with CFR 0.152.
 */
package com.dlconsultant.infolognl.applet;

import com.dlconsultant.infolognl.applet.Decode;
import com.dlconsultant.infolognl.charts.CategoryDataSetChartLoader;
import com.dlconsultant.infolognl.charts.PieChartLoader;
import com.dlconsultant.infolognl.charts.TimeSerieDataSetChartLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class JFreeChartApplet
extends JApplet {
    public void init() {
        Properties config = this.loadConfig();
        if (config == null) {
            this.setBackground(Color.WHITE);
            this.getRootPane().setBackground(Color.WHITE);
            this.getContentPane().setBackground(Color.WHITE);
            return;
        }
        String type = config.getProperty("chart.type");
        JFreeChart chart1 = null;
        if (type == null) {
            return;
        }
        if (type.equalsIgnoreCase("pie") || type.equalsIgnoreCase("pie3D")) {
            PieChartLoader pieloader = new PieChartLoader(config);
            chart1 = pieloader.getChart();
        }
        if (type.equalsIgnoreCase("bar3D") || type.equalsIgnoreCase("bar") || type.equalsIgnoreCase("area") || type.equalsIgnoreCase("stackedarea") || type.equalsIgnoreCase("stackedbar") || type.equalsIgnoreCase("stackedbar3D") || type.equalsIgnoreCase("linechart")) {
            CategoryDataSetChartLoader chartloader = new CategoryDataSetChartLoader(config);
            chart1 = chartloader.getChart();
        }
        if (type.equalsIgnoreCase("time")) {
            TimeSerieDataSetChartLoader loader = new TimeSerieDataSetChartLoader(config);
            chart1 = loader.getChart();
        }
        JTabbedPane tabs = new JTabbedPane();
        if (chart1 == null) {
            return;
        }
        ChartPanel chartPanel = new ChartPanel(chart1, false, false, true, true, true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane((Container)chartPanel);
    }

    public Properties loadConfig() {
        String config = this.getParameter("config");
        if (config == null) {
            System.out.println("Pas de param\u00e8tre Config");
            return null;
        }
        System.out.println("Config :" + this.getCodeBase().getProtocol() + "://" + this.getCodeBase().getHost() + this.getCodeBase().getPort() + "/IMGNG10CLI/" + config);
        try {
            URL url = null;
            url = this.getCodeBase().getPort() == -1 ? new URL(String.valueOf(this.getCodeBase().getProtocol()) + "://" + this.getCodeBase().getHost() + "/IMGNG10CLI/" + config) : new URL(String.valueOf(this.getCodeBase().getProtocol()) + "://" + this.getCodeBase().getHost() + ':' + this.getCodeBase().getPort() + "/IMGNG10CLI/" + config);
            if (config.length() > 4 && config.substring(0, 4).equalsIgnoreCase("http")) {
                url = new URL(config);
            }
            URLConnection connection = null;
            try {
                connection = url.openConnection();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
            InputStream input = null;
            try {
                input = connection.getInputStream();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
            BufferedReader d = null;
            try {
                d = new BufferedReader(new InputStreamReader(input, "8859_1"));
            }
            catch (UnsupportedEncodingException e4) {
                e4.printStackTrace();
                return null;
            }
            Properties props = new Properties();
            try {
                String ligne = d.readLine();
                while (ligne != null) {
                    StringTokenizer token = new StringTokenizer(ligne);
                    String cle = null;
                    String valeur = "";
                    int i = 1;
                    while (token.hasMoreTokens()) {
                        if (i == 1) {
                            cle = token.nextToken("=");
                        } else {
                            valeur = i > 2 ? String.valueOf(valeur) + '=' + token.nextToken() : String.valueOf(valeur) + token.nextToken();
                        }
                        ++i;
                    }
                    if (cle != null && valeur != null) {
                        cle = Decode.decode(cle);
                        valeur = Decode.decode(valeur);
                        props.setProperty(cle, valeur);
                    }
                    ligne = d.readLine();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            return props;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

