package com.infologsolutions.server.watchdog;

import java.io.File;

import org.sadun.util.polling.DirectoryPoller;

public class FileSurveyor {
	private static FileSurveyor uniqueInstance;
	private DirectoryPoller grafcfgDirectoryPoller = new DirectoryPoller();
	private DirectoryPoller stopDirectoryPoller = new DirectoryPoller();
	private File destinationPath;

	private FileSurveyor() {

	}

	public static synchronized FileSurveyor getUniqueInstance() {
		if (uniqueInstance == null) {
			uniqueInstance = new FileSurveyor();
		}
		return uniqueInstance;
	}

	public void demarrerSurveillanceRepertoire(File sourcePath, File destinationPath) {
		File[] paths = { sourcePath };
		this.destinationPath = destinationPath;
		
		grafcfgDirectoryPoller.setDirectories(paths);
		stopDirectoryPoller.setDirectories(paths);

		grafcfgDirectoryPoller.setPollInterval(200);
		stopDirectoryPoller.setPollInterval(200);

		grafcfgDirectoryPoller.setBypassLockedFiles(true);
		stopDirectoryPoller.setBypassLockedFiles(true);
		
		grafcfgDirectoryPoller.setAutoMove(true);
		stopDirectoryPoller.setAutoMove(true);

		grafcfgDirectoryPoller.setAutoMoveDirectory(sourcePath, destinationPath);
		stopDirectoryPoller.setAutoMoveDirectory(sourcePath, destinationPath);

		
		grafcfgDirectoryPoller.setTimeBased(true);
		grafcfgDirectoryPoller.setPollingTimeBased(false);
		stopDirectoryPoller.setTimeBased(true);
		stopDirectoryPoller.setPollingTimeBased(false);

		grafcfgDirectoryPoller.setFilter(new ConfigGrapheFileNameFilter());
		stopDirectoryPoller.setFilter(new StopFileNameFilter());
		
		grafcfgDirectoryPoller.addPollManager(new InfologChartConfigPollManager());
		stopDirectoryPoller.addPollManager(new InfologChartStopPollManager());
		
		grafcfgDirectoryPoller.start();
		stopDirectoryPoller.start();
	}

	public void arreterSurveillance() {
		grafcfgDirectoryPoller.shutdown();
		stopDirectoryPoller.shutdown();
	}
	
	public boolean isAlive(){
		return stopDirectoryPoller.isAlive();
	}

	public File getDestinationPath() {
		return destinationPath;
	}
}
