package com.infologsolutions.server.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

import javax.net.ServerSocketFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfologSocketServer {
	private ServerSocket serverSocket;
	private Logger log = LoggerFactory.getLogger(InfologSocketServer.class);
	private boolean stopRequested = false;

	public void demarrerServeur(int port, char messageDelimiter, SocketProcessHandler socketProcessHandler) {
		if (port < 0) {
			port = 14066;
		}

		try {
			ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
			serverSocket = serverSocketFactory.createServerSocket(port);
			if (log.isInfoEnabled()) {
				log.info("Dmarrage du serveur sur le port : " + port);
			}

			while (true) {
				Socket socket = serverSocket.accept();
				socketProcessHandler.handle(socket);
			}
		} catch (IOException e) {
			if (stopRequested) {
				if (log.isDebugEnabled()) {
					log.debug("Exception suite  la demande d'arrt du serveur.", e);
				}
			} else {
				if (log.isErrorEnabled()) {
					log.error("Arrt du serveur suite  une exception.", e);
				}
			}
		}
	}

	public void arreterSurveillance() {
		try {
			if (log.isInfoEnabled()) {
				log.info("Arrt du serveur");
			}
			stopRequested = true;
			serverSocket.close();
		} catch (IOException e) {
			if (log.isErrorEnabled()) {
				log.error("Exception lors de la demande d'arrt du serveur.", e);
			}
		}
	}

	public boolean isAlive() {
		return !serverSocket.isClosed();
	}
}
