package com.infologsolutions.server.socket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfologCryptoSocketClient {
	private Logger log = LoggerFactory.getLogger(InfologCryptoSocketClient.class);

	private boolean stopRequested = false;
	private static char charDelimiter = '^';

	public InfologCryptoSocketClient() {
	}

	public static void main(String[] args) throws Exception {
		InfologCryptoSocketClient infologChartSocketClient = new InfologCryptoSocketClient();
		String config = new StringBuffer("julien").append(charDelimiter).toString();
		String host = "129.0.0.18";
		int port = 14067;
		infologChartSocketClient.client(config, host, port);
		long avant = System.currentTimeMillis();
		for (int i = 1000; i != 0; i--) {
			infologChartSocketClient.client(config + i, host, port);
		}
		long apres = System.currentTimeMillis();
		System.out.println("Dure en millisecondes : " + (apres - avant));
		infologChartSocketClient.stopRequested = true;
		infologChartSocketClient.client("SHUTDOWNSERVER", host, port);
	}

	public void client(String config, String host, int port) {
		Socket kkSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;

		try {
			kkSocket = new Socket(host, port);
			out = new PrintWriter(kkSocket.getOutputStream(), true);
			in = new BufferedReader(new InputStreamReader(kkSocket.getInputStream()));
		} catch (UnknownHostException e) {
			if (log.isErrorEnabled()) {
				log.error("Hte inconnu :" + host, e);
			}
			System.exit(1);
		} catch (IOException e) {
			if (log.isErrorEnabled()) {
				log.error("Problme d'I/O vers l'hte :" + host, e);
			}
			System.exit(1);
		}

		try {
			if (log.isDebugEnabled()) {
				log.debug("Message  envoy au serveur:" + config);
			}
			out.println(config + charDelimiter);
			out.println("QUIT" + charDelimiter);
			out.flush();
			String fromServer;

			while ((fromServer = in.readLine()) != null) {
				if (log.isDebugEnabled()) {
					log.debug("Message du serveur:" + fromServer);
				}
				System.out.println(fromServer);
			}
			out.close();
			in.close();
			kkSocket.close();
		} catch (IOException e) {
			if (!stopRequested) {
				if (log.isErrorEnabled()) {
					log.error("Problme d'I/O lors de la communication avec l'hte :" + host, e);
				}
			}
		}
	}

}