package com.infologsolutions.server.socket;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfologChartSocketClient {
	private Logger log = LoggerFactory.getLogger(InfologChartSocketClient.class);


	private boolean stopRequested = false;
	private char charDelimiter = '^';

	public InfologChartSocketClient() {
	}

	public static void main(String[] args) throws Exception {
		InfologChartSocketClient infologChartSocketClient = new InfologChartSocketClient();
		String config = infologChartSocketClient.lireFichier("cfggraf190206.txt");
		String host = "129.0.1.7";
		int port = 14066;
		infologChartSocketClient.client(config, host, port);
		infologChartSocketClient.stopRequested = true;
		infologChartSocketClient.client("SHUTDOWNSERVER", host, port);
	}

	public void client(String config, String host, int port) {
		Socket kkSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;

		try {
			kkSocket = new Socket(host, port);
			out = new PrintWriter(kkSocket.getOutputStream(), true);
			in = new BufferedReader(new InputStreamReader(kkSocket.getInputStream()));
		} catch (UnknownHostException e) {
			if (log.isErrorEnabled()) {
				log.error("Hte inconnu :" + host, e);
			}
			System.exit(1);
		} catch (IOException e) {
			if (log.isErrorEnabled()) {
				log.error("Problme d'I/O vers l'hte :" + host, e);
			}
			System.exit(1);
		}

		try {
			if (log.isDebugEnabled()) {
				log.debug("Message  envoy au serveur:" + config);
			}
			out.println(config + charDelimiter);
			out.println("QUIT" + charDelimiter);
			out.flush();
			String fromServer;

			while ((fromServer = in.readLine()) != null) {
				if (log.isDebugEnabled()) {
					log.debug("Message du serveur:" + fromServer);
				}
				System.out.println(fromServer);
			}
			out.close();
			in.close();
			kkSocket.close();
		} catch (IOException e) {
			if (!stopRequested) {
				if (log.isErrorEnabled()) {
					log.error("Problme d'I/O lors de la communication avec l'hte :" + host, e);
				}
			}
		}
	}

	private String lireFichier(String configName) {
		File file = new File(configName);
		InputStream inputStreamConfigFile = null;
		try {
			inputStreamConfigFile = new FileInputStream(file);
		} catch (FileNotFoundException e1) {
			if (log.isErrorEnabled()) {
				log.error("Fichier " + configName + " non trouv.", e1);
			}
		}
		if (inputStreamConfigFile == null) {
			throw new RuntimeException("Le fichier : " + configName + " n'a pas t trouv.");
		}
		BufferedReader in = new BufferedReader(new InputStreamReader(inputStreamConfigFile));
		StringBuffer fictemp = new StringBuffer();
		String line;
		try {
			line = in.readLine();
			while (line != null) {
				fictemp.append(line);
				fictemp.append(charDelimiter);
				line = in.readLine();
			}
			fictemp.append(charDelimiter);

		} catch (IOException e) {
			e.printStackTrace();
		}
		return fictemp.toString();
	}

}