package com.infologsolutions.server.socket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericInfologSocketServerHandler extends Thread {

	private Logger log = LoggerFactory.getLogger(GenericInfologSocketServerHandler.class);
	private InfologSocketServer infologSocketServer;
	private Socket socket;
	private PrintWriter out;
	private BufferedReader in;
	// caractre paragraphe 
	private char messageDelimiter = '\u00A7';
	private SocketProcessHandler socketProcessHandler;

	public GenericInfologSocketServerHandler(InfologSocketServer infologSocketServer, Socket socket, char messageDelimiter,
			SocketProcessHandler socketProcessHandler) {
		this.infologSocketServer = infologSocketServer;
		this.messageDelimiter = messageDelimiter;
		this.socketProcessHandler = socketProcessHandler;
		this.socket = socket;

	}

	public void run() {
		try {
			// fabrication d'une variable permettant l'utilisation du flux de sortie avec des string
			out = new PrintWriter(socket.getOutputStream());
			// fabrication d'une variable permettant l'utilisation du flux d'entre avec des string
			in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		} catch (IOException e) {
			if (log.isErrorEnabled()) {
				log.error("Exception suite  la demande d'arrt du serveur.", e);
			}
		}
		// on indique dans la console la connection d'un nouveau client
		try {

			// la lecture des donnes entrantes se fait caractre par caractre ...
			// ... jusqu' trouver un caractre de fin de chaine
			StringBuffer config = new StringBuffer();
			String line;
			StringBuffer lineBuffer = new StringBuffer();
			char charCur[] = new char[1]; // dclaration d'un tableau de char d'1 lement, _in.read() y stockera le char lu
			while (in.read(charCur) != -1) // attente en boucle des messages provenant du client (bloquant sur _in.read())
			{
				if (charCur[0] == messageDelimiter) {
					line = lineBuffer.toString();
					if (line.trim().equalsIgnoreCase("QUIT")) {
						break;
					}
					if (line.trim().equalsIgnoreCase("SHUTDOWNSERVER")) {
						infologSocketServer.arreterSurveillance();
						break;
					}
					config.append(lineBuffer).append(messageDelimiter);
					lineBuffer.delete(0, lineBuffer.length());
				} else {
					lineBuffer.append(charCur[0]);
				}
			}

			if (config.length() != 0) {
				String response = socketProcessHandler.handleLineCallBack(config.toString(), messageDelimiter);
				if (response != null) {
					out.println(response);
					out.flush();
				}
			} else {
				out.println("99No data received");
				out.flush();
			}

		} catch (Exception e) {
			if (log.isErrorEnabled()) {
				log.error("Une exception a t soulev lors de la rception du flux.", e);
			}
		} finally // finally se produira le plus souvent lors de la deconnexion du client
		{
			if (out != null) {
				out.close();
			}
			try {
				socket.close(); // fermeture du socket si il ne l'a pas dj t ( cause de l'exception leve plus haut)
			} catch (IOException e) {
				if (log.isErrorEnabled()) {
					log.error("Une exception a t soulev lors de la cloture du socket.", e);
				}
			}
		}
	}

}
