/*
 * Created on 28 aot 2003
 * 
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.infologsolutions.server.charts;

import java.awt.Color;
import java.util.Map;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.general.DefaultPieDataset;

/**
 * @author DUMETIER
 * 
 * To change the template for this generated type comment go to Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PieChartLoader extends DefaultChartLoader {

	public PieChartLoader(Map props) {
		super(props);
	}

	public JFreeChart getChart() {
		DefaultPieDataset data = new DefaultPieDataset();
		for (int i = 1; _properties.containsKey("pie.key" + i); i++) {
			String cle = (String) _properties.get("pie.key" + i);
			String valeur = (String) _properties.get("pie.value" + i);
			Double d = new Double(valeur);
			data.setValue(cle, d);
		}
		JFreeChart chart = null;
		String type = (String) _properties.get("chart.type");
		if (type.equalsIgnoreCase("pie")) {
			chart = createPieChart(data);
		}
		if (type.equalsIgnoreCase("pie3D")) {
			chart = createPie3DChart(data);
		}

		if (isLegendVisible()) {
			LegendTitle legend = chart.getLegend();
			legend.setPosition(getLegendAnchor());
		}

		return chart;
	}

	/**
	 * @param data
	 * @return a chart
	 */
	private JFreeChart createPie3DChart(DefaultPieDataset data) {
		JFreeChart chart = ChartFactory.createPieChart3D(getTitle(), // chart title
				data, // data
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		PiePlot3D plot = (PiePlot3D) chart.getPlot();
		configurePlot(plot);

		return chart;
	}

	private void configurePlot(PiePlot plot) {
		plot.setForegroundAlpha(0.60f);
		plot.setInteriorGap(0.33);

		StandardPieSectionLabelGenerator pieSectionLabelGenerator = new StandardPieSectionLabelGenerator("{0} ({2})");
		plot.setLabelGenerator(pieSectionLabelGenerator);

		plot.setNoDataMessage("No data available");
		plot.setToolTipGenerator(new StandardPieToolTipGenerator());
		plot.setCircular(true);
		if (isLegendVisible()) {
			plot.setLegendLabelGenerator(new StandardPieSectionLabelGenerator("{0}"));
		} else {
			plot.setLegendLabelGenerator(new StandardPieSectionLabelGenerator(""));
		}
	}

	/**
	 * @param data
	 * @return a chart
	 */
	private JFreeChart createPieChart(DefaultPieDataset data) {
		JFreeChart chart = ChartFactory.createPieChart(getTitle(), // chart title
				data, // data
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		PiePlot plot = (PiePlot) chart.getPlot();
		configurePlot(plot);

		// On met en valeur des parts du camembert
		int nb = data.getItemCount();
		for (int i = 1; i <= nb; i++) {
			String cle = (String) _properties.get("pie.exploded" + i);
			if (cle != null) {
				if (cle.equalsIgnoreCase("true")) {
					plot.setExplodePercent(i - 1, 1.00);
				}
			}
		}
		return chart;
	}
}
