package com.infologsolutions.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigLoader {

	public Properties loadConfigFromFile(File file) {
		// BufferedReader d = new BufferedReader(new InputStreamReader(input));
		BufferedReader d = null;
		try {
			InputStream input = new FileInputStream(file);
			d = new BufferedReader(new InputStreamReader(input, "8859_1"));
		} catch (UnsupportedEncodingException e4) {
			// TODO Auto-generated catch block
			e4.printStackTrace();
			return null;
		} catch (FileNotFoundException e4) {
			// TODO Auto-generated catch block
			e4.printStackTrace();
			return null;
		}
		Properties props = new Properties();
		// On boucle sur la lecture des ligne du fichier
		try {
			for (String ligne = d.readLine(); ligne != null; ligne = d.readLine()) {
				StringTokenizer token = new StringTokenizer(ligne);
				String cle = null;
				String valeur = "";
				for (int i = 1; token.hasMoreTokens(); i++) {
					if (i == 1) {
						cle = token.nextToken("=");

					} else {
						if (i > 2) {
							valeur = valeur + '=' + token.nextToken();
						} else {
							valeur = valeur + token.nextToken();
						}
					}
				}
				if (cle != null && valeur != null) {
					cle = Decode.decode(cle);
					valeur = Decode.decode(valeur);
					props.setProperty(cle, valeur);
				}
			}
		} catch (IOException e3) {
			// TODO Auto-generated catch block
			e3.printStackTrace();
		}

		return props;
	}
}
