package com.infologsolutions.server.watchdog;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;

import org.sadun.util.polling.BasePollManager;
import org.sadun.util.polling.FileFoundEvent;
import org.sadun.util.polling.FileSetFoundEvent;

import com.infologsolutions.server.ConfigLoader;
import com.infologsolutions.server.GraphService;

public class InfologChartConfigPollManager extends BasePollManager {
	public void fileSetFound(FileSetFoundEvent fileSetFoundEvent) {
		super.fileSetFound(fileSetFoundEvent);
		File[] files = fileSetFoundEvent.getFiles();
		for (int i = 0; i < files.length; i++) {
			File file = files[i];
			traiterFichier(file);
		}

	}

	public void fileFound(FileFoundEvent evt) {
		super.fileFound(evt);
		File configFile = evt.getFile();
		traiterFichier(configFile);
	}

	public void traiterFichier(File fichier) {
		ConfigLoader configLoader = new ConfigLoader();
		Properties configProperties = configLoader.loadConfigFromFile(fichier);
		if (!configProperties.isEmpty()) {

			GraphService graphService = new GraphService();
			// On gnre une nouvelle hashMap, mme si Properties implmente Map car on limite les accs synchronized  une priode plus
			// restreinte
			graphService.generateGraphe(new HashMap(configProperties), FileSurveyor.getUniqueInstance().getDestinationPath());
		}
		fichier.delete();

	}
}
