package com.infologsolutions.server.socket;

import java.net.Socket;

import org.apache.commons.lang.StringUtils;

import com.infologsolutions.server.HashGenerator;

public class InfologCryptoSocketServerHandler extends SocketServerHandler implements SocketProcessHandler {

	public InfologCryptoSocketServerHandler(InfologSocketServer infologSocketServer, char messageDelimiter) {
		super(infologSocketServer, messageDelimiter);
	}

	public String handleLineCallBack(String buffer, char messageDelimiter) {
		HashGenerator hashGenerator = new HashGenerator(StringUtils.replaceChars(buffer, "" + messageDelimiter, ""));
		return hashGenerator.compute();
	}

	public void handle(Socket socket) {
		GenericInfologSocketServerHandler genericInfologSocketServerHandler = new GenericInfologSocketServerHandler(
				getInfologSocketServer(), socket, getMessageDelimiter(), this);
		genericInfologSocketServerHandler.start();
	}
}
