package com.infologsolutions.server.socket;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Properties;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.infologsolutions.server.GraphService;

public class InfologChartSocketServerHandler extends SocketServerHandler implements SocketProcessHandler {

	private Logger log = LoggerFactory.getLogger(InfologChartSocketServerHandler.class);
	private File destinationPath;

	public InfologChartSocketServerHandler(InfologSocketServer infologSocketServer, char messageDelimiter, File destinationPath) {
		super(infologSocketServer, messageDelimiter);
		this.destinationPath = destinationPath;
	}

	public String handleLineCallBack(String buffer, char messageDelimiter) {
		Properties configProperties = new Properties();
		String bufferTmp = StringUtils.replaceChars(buffer, "" + messageDelimiter, "\n");
		try {
			configProperties.load(new ByteArrayInputStream(bufferTmp.getBytes()));
		} catch (IOException e) {
			if (log.isErrorEnabled()) {
				log.error("Une exception a t soulev lors de la rcupration du flux.", e);
			}
		}
		GraphService graphService = new GraphService();
		File file = graphService.generateGraphe(new HashMap(configProperties), destinationPath);
		String response;
		if (file != null) {
			response = file.getAbsolutePath();

		} else {
			response = "99Image not created";
		}
		return response;
	}

	public void handle(Socket socket) {
		GenericInfologSocketServerHandler genericInfologSocketServerHandler = new GenericInfologSocketServerHandler(getInfologSocketServer(), socket, getMessageDelimiter(), this);
		genericInfologSocketServerHandler.start();
	}

}
