/*
 * Created on 28 aot 2003
 * 
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.infologsolutions.server.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;

/**
 * @author DUMETIER
 * 
 * To change the template for this generated type comment go to Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TimeSerieDataSetChartLoader extends DefaultChartLoader {
	private DateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSS");
	private DateFormat precision1 = new SimpleDateFormat("yyyy");
	private DateFormat precision2 = new SimpleDateFormat("MM-yyyy");
	private DateFormat precision3 = new SimpleDateFormat("yyyy-MM-dd");
	private DateFormat precision4 = new SimpleDateFormat("yyyy-MM ww");
	private DateFormat precision5 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
	private DateFormat precision6 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
	private DateFormat precision7 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	/**
	 * @param props
	 * 
	 */
	public TimeSerieDataSetChartLoader(Map props) {
		super(props);
	}

	public JFreeChart getChart() {
		TimeSeriesCollection dataset = new TimeSeriesCollection();

		// Rcupration du niveau de prcision
		String precisionString = "year";
		if (_properties.get("time.precision") != null) {
			precisionString = (String) _properties.get("time.precision");
		}

		int precision = 1;
		if (precisionString.equalsIgnoreCase("year")) {
			precision = 1;
		} else if (precisionString.equalsIgnoreCase("month")) {
			precision = 2;
		} else if (precisionString.equalsIgnoreCase("day")) {
			precision = 3;
		} else if (precisionString.equalsIgnoreCase("week")) {
			precision = 4;
		} else if (precisionString.equalsIgnoreCase("hour")) {
			precision = 5;
		} else if (precisionString.equalsIgnoreCase("minute")) {
			precision = 6;
		} else if (precisionString.equalsIgnoreCase("second")) {
			precision = 7;
		}

		// Rcupration des noms de catgories
		TimeSeries serie = null;
		for (int i = 1; _properties.containsKey("time.serie" + i + ".date1"); i++) {

			String serieName = "";
			if (_properties.get("time.serie" + i + ".name") != null) {
				serieName = (String) _properties.get("time.serie" + i + ".name");
			}

			switch (precision) {
			case 1:
				serie = new TimeSeries(serieName, Year.class);
				break;
			case 2:
				serie = new TimeSeries(serieName, Month.class);
				break;
			case 3:
				serie = new TimeSeries(serieName, Day.class);
				break;
			case 4:
				serie = new TimeSeries(serieName, Week.class);
				break;
			case 5:
				serie = new TimeSeries(serieName, Hour.class);
				break;
			case 6:
				serie = new TimeSeries(serieName, Minute.class);
				break;
			case 7:
				serie = new TimeSeries(serieName, Second.class);
				break;
			default:
				serie = new TimeSeries(serieName, Year.class);
				break;
			}

			for (int j = 1; _properties.containsKey("time.serie" + i + ".date" + j); j++) {

				try {
					String dateString = (String) _properties.get("time.serie" + i + ".date" + j);
					String value = (String) _properties.get("time.serie" + i + ".value" + j);
					if (value != null && dateString != null) {
						Date ladate = convertDate(dateString);
						if (ladate != null) {

							Double d = new Double(value);
							switch (precision) {
							case 1:
								serie.add(new Year(ladate), d);
								break;
							case 2:
								serie.add(new Month(ladate), d);
								break;
							case 3:
								serie.add(new Day(ladate), d);
								break;
							case 4:
								serie.add(new Week(ladate), d);
								break;
							case 5:
								serie.add(new Hour(ladate), d);
								break;
							case 6:
								serie.add(new Minute(ladate), d);
								break;
							case 7:
								serie.add(new Second(ladate), d);
								break;
							default:
								serie.add(new Year(ladate), d);
								break;
							}
						}
					}
				} catch (NumberFormatException e) {
					e.printStackTrace();
				} catch (SeriesException e1) {
				}
			}
			dataset.addSeries(serie);
		}

		String moyenne = (String) _properties.get("time.moyenne");
		String moyenneTexte = (String) _properties.get("time.moyenne.texte");
		if (moyenneTexte == null) {
			moyenneTexte = "(Average)";
		}
		if (moyenne != null && moyenne.equalsIgnoreCase("true")) {
			TimeSeriesCollection dataset2 = MovingAverage.createMovingAverage(dataset, " " + moyenneTexte, serie.getItemCount(), 0);
			for (int i = 0; i < dataset2.getSeriesCount(); i++) {
				dataset.addSeries(dataset2.getSeries(i));
			}
		}
		JFreeChart chart = createChart(dataset, precision);

		if (isLegendVisible()) {
			LegendTitle legend = chart.getLegend();
			legend.setPosition(getLegendAnchor());
		}


		return chart;
	}

	/**
	 * @param dateString
	 * @return a date
	 */
	private Date convertDate(String dateString) {
		// Format the current time.
		Date ladate = null;
		synchronized (formatter) {
			try {
				ladate = formatter.parse(dateString);
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}

		return ladate;
	}

	private JFreeChart createChart(XYDataset dataset, int precision) {

		JFreeChart chart = ChartFactory.createTimeSeriesChart(getTitle(), (String) _properties.get("time.libelle.temps"),
				(String) _properties.get("time.libelle.valeurs"), dataset, isLegendVisible(), areTooltipsVisible(), false);

		chart.setBackgroundPaint(Color.white);

		XYPlot plot = chart.getXYPlot();
		plot.setBackgroundPaint(Color.white);
		plot.setDomainGridlinePaint(Color.lightGray);
		plot.setRangeGridlinePaint(Color.lightGray);

		String sommet = (String) _properties.get("time.sommet.visible");
		if (sommet != null && sommet.equalsIgnoreCase("true")) {
			XYItemRenderer renderer = plot.getRenderer();
			if (renderer instanceof StandardXYItemRenderer) {
				StandardXYItemRenderer rr = (StandardXYItemRenderer) renderer;
				rr.setShapesFilled(true);
			}
		}

		// Modification de l'paisseur des lignes traces
		setLineStroke(dataset, plot);

		DateAxis axis = (DateAxis) plot.getDomainAxis();
		switch (precision) {
		case 1:
			axis.setDateFormatOverride(precision1);
			break;
		case 2:
			axis.setDateFormatOverride(precision2);
			break;
		case 3:
			axis.setDateFormatOverride(precision3);
			break;
		case 4:
			axis.setDateFormatOverride(precision4);
			break;
		case 5:
			axis.setDateFormatOverride(precision5);
			break;
		case 6:
			axis.setDateFormatOverride(precision6);
			break;
		case 7:
			axis.setDateFormatOverride(precision7);
			break;
		default:
			axis.setDateFormatOverride(precision1);
			break;
		}
		return chart;
	}

	/**
	 * @param data
	 * @param plot
	 */
	private void setLineStroke(XYDataset data, XYPlot plot) {
		// set the bar colors for the chart...
		BasicStroke stroke = new BasicStroke(2.0f);
		for (int i = 0; i < data.getSeriesCount(); i++) {
			plot.getRenderer().setSeriesStroke(i, stroke);
		}
	}

}