/*
 * Created on 28 aot 2003
 * 
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.infologsolutions.server.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.DefaultCategoryDataset;

/**
 * @author DUMETIER
 * 
 * To change the template for this generated type comment go to Window>Preferences>Java>Code Generation>Code and Comments
 */
public class CategoryDataSetChartLoader extends DefaultChartLoader {

	/**
	 * @param props
	 * 
	 */
	public CategoryDataSetChartLoader(Map props) {
		super(props);
	}

	public JFreeChart getChart() {
		DefaultCategoryDataset data = new DefaultCategoryDataset();

		// Rcupration des noms de sries
		ArrayList series = new ArrayList();
		for (int i = 1; _properties.containsKey("serie.name" + i); i++) {
			if ((String)_properties.get("serie.name" + i) != null) {
				series.add(_properties.get("serie.name" + i));
			}
		}

		// Rcupration des noms de catgories
		ArrayList categories = new ArrayList();
		for (int i = 1; _properties.containsKey("category.name" + i); i++) {
			if (_properties.get("category.name" + i) != null) {
				categories.add(_properties.get("category.name" + i));
			}
		}

		Iterator seriesIt = series.iterator();
		while (seriesIt.hasNext()) {
			String serieName = (String) seriesIt.next();
			Iterator categoriesIt = categories.iterator();
			while (categoriesIt.hasNext()) {
				String categoryName = (String) categoriesIt.next();
				String cle = (new StringBuffer(serieName).append('.').append(categoryName)).toString();
				if (_properties.containsKey(cle)) {
					String valeur = (String)_properties.get(cle);
					if (valeur != null) {
						try {
							Double db = new Double(valeur);
							data.addValue(db, serieName, categoryName);
						} catch (NumberFormatException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}
			}
		}

		JFreeChart chart = null;
		String type = (String)_properties.get("chart.type");
		if (type.equalsIgnoreCase("bar3D")) {
			chart = createBarChart3DChart(data);
		} else if (type.equalsIgnoreCase("bar")) {
			chart = createBarChart(data);
		} else if (type.equalsIgnoreCase("area")) {
			chart = createAreaChart(data);
		} else if (type.equalsIgnoreCase("stackedarea")) {
			chart = createStackedAreaChart(data);
		} else if (type.equalsIgnoreCase("stackedbar")) {
			chart = createStackedBarChart(data);
		} else if (type.equalsIgnoreCase("stackedbar3d")) {
			chart = createStackedBarChart3D(data);
		} else if (type.equalsIgnoreCase("linechart")) {
			chart = createLineChart(data);
		}
		if (isLegendVisible()) {
			LegendTitle legend = chart.getLegend();
			legend.setPosition(getLegendAnchor());
		}

		return chart;
	}

	/**
	 * @param data
	 * @return Jfreechart
	 */
	private JFreeChart createBarChart3DChart(DefaultCategoryDataset data) {

		JFreeChart chart = ChartFactory.createBarChart3D(getTitle(), // chart title
				(String)_properties.get("series.name"), // titres de series
				(String)_properties.get("categories.name"), // titres de series
				data, // data
				getPlotOrientation(), // orientation
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		CategoryPlot plot = chart.getCategoryPlot();
		plot.setForegroundAlpha(0.60f);
		setBarColors(data, plot);
		return chart;
	}

	/**
	 * @param data
	 * @param plot
	 */
	private void setBarColors(DefaultCategoryDataset data, CategoryPlot plot) {
		// set the bar colors for the chart...
		for (int i = 0; i < data.getRowCount(); i++) {
			Color color = Color.red;
			if (_properties.containsKey(data.getRowKey(i) + ".color")) {
				String couleur = (String)_properties.get(data.getRowKey(i) + ".color");
				try {
					color = Color.decode(couleur);
					plot.getRenderer().setSeriesPaint(i, color);
				} catch (NumberFormatException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * @param data
	 * @param plot
	 */
	private void setLineStroke(DefaultCategoryDataset data, CategoryPlot plot) {
		// set the bar colors for the chart...
		BasicStroke stroke = new BasicStroke(2.0f);
		for (int i = 0; i < data.getRowCount(); i++) {
			plot.getRenderer().setSeriesStroke(i, stroke);
		}
	}

	private JFreeChart createBarChart(DefaultCategoryDataset data) {

		JFreeChart chart = ChartFactory.createBarChart(getTitle(), // chart title
				(String)_properties.get("categories.name"), // titres de series
				(String)_properties.get("series.name"), // titres des valeurs
				data, // data
				getPlotOrientation(), // orientation
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		CategoryPlot plot = chart.getCategoryPlot();
		plot.setForegroundAlpha(0.60f);
		setBarColors(data, plot);
		return chart;
	}

	private JFreeChart createAreaChart(DefaultCategoryDataset data) {

		JFreeChart chart = ChartFactory.createAreaChart(getTitle(), // chart title
				(String)_properties.get("categories.name"), // titres de series
				(String)_properties.get("series.name"), // titres des valeurs
				data, // data
				getPlotOrientation(), // orientation
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		CategoryPlot plot = chart.getCategoryPlot();
		plot.setForegroundAlpha(0.60f);
		setBarColors(data, plot);
		return chart;
	}

	private JFreeChart createStackedAreaChart(DefaultCategoryDataset data) {

		JFreeChart chart = ChartFactory.createStackedAreaChart(getTitle(),
		// chart title
				(String)_properties.get("categories.name"), // titres de series
				(String)_properties.get("series.name"), // titres des valeurs
				data, // data
				getPlotOrientation(), // orientation
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		CategoryPlot plot = chart.getCategoryPlot();
		plot.setForegroundAlpha(0.60f);
		setBarColors(data, plot);
		return chart;
	}

	private JFreeChart createStackedBarChart(DefaultCategoryDataset data) {

		JFreeChart chart = ChartFactory.createStackedBarChart(getTitle(),
		// chart title
				(String)_properties.get("categories.name"), // titres de series
				(String)_properties.get("series.name"), // titres des valeurs
				data, // data
				getPlotOrientation(), // orientation
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		CategoryPlot plot = chart.getCategoryPlot();
		plot.setForegroundAlpha(0.60f);
		setBarColors(data, plot);
		return chart;
	}

	private JFreeChart createStackedBarChart3D(DefaultCategoryDataset data) {

		JFreeChart chart = ChartFactory.createStackedBarChart3D(getTitle(),
		// chart title
				(String)_properties.get("categories.name"), // titres de series
				(String)_properties.get("series.name"), // titres des valeurs
				data, // data
				getPlotOrientation(), // orientation
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		CategoryPlot plot = chart.getCategoryPlot();
		plot.setForegroundAlpha(0.60f);
		setBarColors(data, plot);
		return chart;
	}

	private JFreeChart createLineChart(DefaultCategoryDataset data) {

		JFreeChart chart = ChartFactory.createLineChart(getTitle(), // chart title
				(String)_properties.get("categories.name"), // titres de series
				(String)_properties.get("series.name"), // titres des valeurs
				data, // data
				getPlotOrientation(), // orientation
				isLegendVisible(), // include legend
				areTooltipsVisible(), false);

		// set the background color for the chart...
		chart.setBackgroundPaint(Color.white);
		CategoryPlot plot = chart.getCategoryPlot();
		plot.setForegroundAlpha(0.60f);
		setBarColors(data, plot);
		setLineStroke(data, plot);
		return chart;
	}

}
