package com.infologsolutions.server;

import java.security.MessageDigest;

public class HashGenerator {
	private String inStr;
	private MessageDigest digest;

	public HashGenerator(String inStr) {
		this.inStr = inStr;
		try {
			digest = MessageDigest.getInstance("SHA1");
		} catch (Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
	}

	public String compute() {
		digest.update(inStr.getBytes());
		byte array[] = digest.digest();
		StringBuffer sb = new StringBuffer(32);
		for (int j = 0; j < array.length; j++) {
			int b = array[j] & 0xff;
			if (b < 16)
				sb.append('0');
			sb.append(Integer.toHexString(b));
		}

		return sb.toString().toUpperCase();
	}

	public static void main(String args[]) {
		if (args == null || args.length != 1) {
			System.out.println("99Le nombre d'argument est incorrect");
			return;
		}
		String parametre = args[0];
		if (parametre == null || parametre.trim().length() == 0) {
			System.out.println("99La chaine de caract\350re pass\351e en param\350tre est vide.");
		}
		HashGenerator hashGenerator = new HashGenerator(args[0]);
		System.out.println("00" + hashGenerator.compute());
	}

}