package com.infologsolutions.server;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.infologsolutions.server.charts.CategoryDataSetChartLoader;
import com.infologsolutions.server.charts.PieChartLoader;
import com.infologsolutions.server.charts.TimeSerieDataSetChartLoader;

public class GraphService {
	private Logger log = LoggerFactory.getLogger(GraphService.class);

	private static boolean isBlank(String value) {
		if (value == null) {
			return true;
		} else if (value.length() == 0) {
			return true;
		} else {
			return value.trim().length() == 0;
		}
	}

	public File generateGraphe(Map config, File outputPath) {

		String outputFileName = (String) config.get("chart.image.name");
		if (isBlank(outputFileName)) {
			return null;
		}
		String fileSeparator = System.getProperty("file.separator");
		StringBuffer outputBuffer = new StringBuffer(outputPath.getPath());
		if (outputPath.getPath().length() > 0 && !outputPath.getPath().substring(outputPath.getPath().length() - 1).equals(fileSeparator)) {
			outputBuffer.append(fileSeparator);
		}
		String output = outputBuffer.append(outputFileName).toString();

		// Analyse du type de graph
		String type = (String) config.get("chart.type");
		JFreeChart chart1 = null;
		if (type == null) {
			return null;
		}
		if (type.equalsIgnoreCase("pie") || type.equalsIgnoreCase("pie3D")) {
			PieChartLoader pieloader = new PieChartLoader(config);
			chart1 = pieloader.getChart();
		}
		if (type.equalsIgnoreCase("bar3D") || type.equalsIgnoreCase("bar") || type.equalsIgnoreCase("area")
				|| type.equalsIgnoreCase("stackedarea") || type.equalsIgnoreCase("stackedbar") || type.equalsIgnoreCase("stackedbar3D")
				|| type.equalsIgnoreCase("linechart")) {
			CategoryDataSetChartLoader chartloader = new CategoryDataSetChartLoader(config);
			chart1 = chartloader.getChart();
		}
		if (type.equalsIgnoreCase("time")) {
			TimeSerieDataSetChartLoader loader = new TimeSerieDataSetChartLoader(config);
			chart1 = loader.getChart();
		}

		if (chart1 == null) {
			return null;
		}
		int width = 500;
		int height = 500;
		try {
			width = Integer.parseInt((String) config.get("chart.image.width"));
			height = Integer.parseInt((String) config.get("chart.image.height"));
		} catch (NumberFormatException e) {
			e.printStackTrace();
		}

		BufferedImage bufferedImage = chart1.createBufferedImage(width, height);
		File file = null;
		try {
			file = new File(output);
			byte[] image = ChartUtilities.encodeAsPNG(bufferedImage);
			FileOutputStream fileOutputStream = new FileOutputStream(file);
			fileOutputStream.write(image);
			fileOutputStream.close();

		} catch (IOException e) {
			if (log.isErrorEnabled()) {
				log.error("Unabled to create image : " + output, e);
			}
		}
		return file;
	}
}
